@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
 
 <div class="content-header">
  <div class="container-fluid">
   <div class="row mb-2">
    <div class="col-sm-6">
     <h1 class="m-0">Manage Setting</h1>
    </div><!-- /.col -->
    <div class="col-sm-6">
     <ol class="breadcrumb float-sm-right">
      <li class="breadcrumb-item"><a href="#">Home</a></li>
      <li class="breadcrumb-item active">Setting</li>
     </ol>
    </div><!-- /.col -->
   </div><!-- /.row -->
  </div><!-- /.container-fluid -->
 </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         <div class="card-header">
          <h3>Setting List
             @if($countsetting < 1)
           <a href="{{route('web_setting.add')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-plus-circle"></i> Add Setting</a>
           @endif
          </h3>
         </div>
              
         <!-- /.card-header -->
         <div class="card-body">
          <table id="example1" class="table table-bordered table-striped">
            <thead>
             <tr>
              <th>Cell</th>
              <th>IP Phone</th>
              <th>Fax</th>
              <th>Email</th>
              <th>Facebook UR</th>
              <th>Address</th>
              <th>Action</th>
              </tr>
             </thead>

             <tbody>
               @foreach($allData as $key => $setting)
              <tr>
               <td>{{$setting->cell}}</td>
               <td>{{$setting->ip_phone}}</td>
               <td>{{$setting->fax}}</td>
               <td>{{$setting->email}}</td>
               <td>{{$setting->facebook}}</td>
               <td>{!!$setting->address!!}</td>
               <td>
                <a title="Edit" href="{{route('web_setting.edit',$setting->id)}}" class="btn btn-sm btn-primary" ><i class="fa fa-edit"></i></a>
                <a title="Delete" href="{{route('web_setting.delete',$setting->id)}}" id="delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>
               </td>
              </tr>

              @endforeach
             </tbody>

            
            </table>
           </div>
          </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  @endsection