@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Setting</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Setting</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
   <div class="row">
    <div class="col-12">

     <div class="card">

      <div class="card-header">
       <h3>Update Setting 
        <a href="{{route('web_setting.view')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-list"></i>Setting List</a>
       </h3>
      </div>
   
      <!-- /.card-header -->
      <div class="card-body">
       <form method="POST" action="{{route('web_setting.update',$editData->id)}}" id="myForm" enctype="multipart/form-data">
        @csrf
         <div class="form-row">

          <div class="form-group col-md-6">
           <label for="name">Cell Nunber</label>
            <input type="text" name="cell" class="form-control" value="{{$editData->cell}}" >
            <font style="color:red">{{($errors->has('cell'))?($errors->first('cell')):'' }}</font>
          </div>

          <div class="form-group col-md-6">
           <label for="name">IP Phone</label>
            <input type="text" name="ip_phone" class="form-control" value="{{$editData->ip_phone}}" >
          </div>

          <div class="form-group col-md-6">
           <label for="name">Fax</label>
            <input type="text" name="fax" class="form-control" value="{{$editData->fax}}">
          </div>

          <div class="form-group col-md-6">
           <label for="name">Email</label>
            <input type="text" name="email" class="form-control" value="{{$editData->email}}">
            <font style="color:red">{{($errors->has('email'))?($errors->first('email')):'' }}</font>
          </div>

          <div class="form-group col-md-6">
           <label for="name">Facebook URL</label>
           <input type="text" name="facebook" class="form-control" value="{{$editData->facebook}}">
          </div>

          <div class="form-group col-md-6">
           <label for="name">Address</label>
             <textarea id="summernote" name="address" type="text">{!!$editData->address!!}</textarea>
            <font style="color:red">{{($errors->has('address'))?($errors->first('address')):'' }}</font>
          </div>
         
           <div class="form-group col-md-6" style="padding-top:30px;">
            <input type="submit" value="Update"  class="btn btn-primary">
           </div>


          </div>
         </form>

        
        </div>
       </div>
       <!-- /.card -->
      </div>
     <!-- /.col -->
     </div>
     <!-- /.row -->
    </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->




  <script>
$(function () {
  $('#myForm').validate({
    rules: {
    cell: {
     required: true,
    },
    email: {
     required: true,
    },
    address: {
     required: true,
    }, 
    },
    messages: {
     cell: {
        required: "Please enter Phone Number",
      },
      email: {
        required: "Please enter @ Email",
      },
      address: {
        required: "Please enter Address",
      },
     
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script> 


  @endsection