@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Vision & Mision</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Vision & Mision</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         <div class="card-header">
                <h3>Manage Vision & Mision
                 @if($countvision < 1)
                  <a href="{{route('vision.add')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-plus-circle"></i>Add Vision & Mision</a>
                  @endif


                </h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  
                <thead>
                  <tr>
                    <th>Vision </th>
                    <th>Mision</th>
                    <th>Action</th>
                  </tr>
                  </thead>

                  <tbody>

                @foreach($allData as $vision)
                  <tr>
                    <td>{!!$vision->vision!!}</td>
                    <td>{!!$vision->mision!!}</td>
                    <td>
                      <a title="Edit" href="{{route('vision.edit',$vision->id)}}" class="btn btn-sm btn-primary" ><i class="fa fa-edit"></i></a>
                      <a title="Delete" href="{{route('vision.delete',$vision->id)}}" id="delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>
                    </td>
    
                  </tr>

                   @endforeach



                </table>
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  @endsection