@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Solution</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Solution</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         <div class="card-header">
                <h3>Manage Solution
                  <a href="{{route('solution.add')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-plus-circle"></i> Add Solution</a>


                </h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  
                <thead>
                  <tr>
                    <th>Show Sl</th>
                    <th>Category Name</th>
                    <th>Solution Name</th>
                    <th>Title</th>
                    <th>Short Detalis</th>
                    <th>Description</th>
                    <th align="center">Image</th>
                    <th align="center">Status</th>
                    <th align="center">Action</th>
                  </tr>
                  </thead>

                  <tbody>

                  @foreach($alldata as $key => $product)
                  <tr>
                
                    <td>{{$key+1}}</td>
                    <td>{{ $product->category->category_name }}</td>
                    <td>{{$product->product_name}}</td>
                    <td>{{$product->title}}</td>
                    <td>{!! $product->short_detalis !!}</td>
                    <td>{!! $product->description !!}</td>
                    <td>
                     <center><img src="{{(!empty($product->image))?url('public/upload/product_image/'.$product->image):url('public/upload/No-image.jpg')}}" width="70px;" height="70px;"></center></td>

                     <td align="center">
                       @if($product->status=='0')
                        <a href="{{route('solution.inacative',$product->id)}}" class="btn btn-primary btn-sm">Active</a>
                       @else
                        <a href="{{route('solution.active',$product->id)}}" class="btn btn-danger btn-sm">Inactive</a>
                       @endif

                     </td>
              
                    <td>           
                      <a title="Edit" href="{{route('solution.edit',$product->id)}}" class="btn btn-sm btn-primary" ><i class="fa fa-edit"></i></a>
                      <a title="Delete" href="{{route('solution.delete',$product->id)}}" id="delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>
                    </td>

                   
                  </tr>

                   @endforeach



                </table>
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  @endsection