@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Logo</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Logo</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         <div class="card-header">
          <h3>Logo List
           @if($countlogo < 1)
            <a href="{{route('logo.add')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-plus-circle"></i> Add Logo</a>
           @endif
          </h3>
         </div>
             
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  
                <thead>
                  <tr>
                    <th>SL</th>
                    <th>Image</th>
                    <th>Action</th>
                  </tr>
                  </thead>

                  <tbody>

                  @foreach($allData as $key => $logo)
                  <tr>
           
                    <td>{{$key+1}}</td>
                    <td align="center"><img src="{{!empty($logo->image)?url('public/upload/logo_images/'.$logo->image):url('public/upload/No-image.jpg')}}" class="img-fluid" style="width:130px;"></td>
                    <td>
                      <a title="Edit" href="{{route('logo.edit',$logo->id)}}" class="btn btn-sm btn-primary" ><i class="fa fa-edit"></i></a>
                      <a title="Delete" href="{{route('logo.delete',$logo->id)}}" id="delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>
                    </td>
    
                  </tr>

                   @endforeach



                </table>
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  @endsection