@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Career</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Product Career</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         <div class="card-header">
                <h3>User Career
                  <a href="{{route('jobcontent.add')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-plus-circle"></i> Add Career</a>


                </h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  
                <thead>
                  <tr>
                    <th>Name</th>
                    <th>Vacancy</th>
                    <th>Employment Status</th>
                    <th>Salary</th>
                    <th>Workplace</th>
                    <th>Job Location</th>
                    <th>Apply Last Date</th>
                    <th align="center">Status</th>
                    <th align="center">Action</th>
                  </tr>
                  </thead>

                  <tbody>

                  @foreach($alldata as $key => $job)
                  <tr>
                
                    <td>{{$job->name}}</td>
                    <td>{{$job->job_content}}</td>
                    <td>{{$job->employment_status}}</td>
                    <td>{{$job->salary}}</td>
                    <td>{{$job->workplace}}</td>
                    <td>{{$job->joblocation}}</td>
                    <td>{{$job->last_date}}</td>

                  
                     <td align="center">
                       @if($job->status=='0')
                        <a href="{{route('jobcontent.inacative',$job->id)}}" class="btn btn-primary btn-sm">Active</a>
                       @else
                        <a href="{{route('jobcontent.active',$job->id)}}" class="btn btn-danger btn-sm">Inactive</a>
                       @endif

                     </td>
              
                    <td>           
                      <a title="Edit" href="{{route('jobcontent.edit',$job->id)}}" class="btn btn-sm btn-primary" ><i class="fa fa-edit"></i></a>
                      <a title="Delete" href="{{route('jobcontent.delete',$job->id)}}" id="delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>
                    </td>

                   
                  </tr>

                   @endforeach



                </table>
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  @endsection