@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Career</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Career</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         
         <div class="card-header">
          <h3>Add Career
           <a href="{{route('jobcontent.view')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-list"></i> Career List</a>
          </h3>
         </div>
              
         <!-- /.card-header -->
         <div class="card-body">
          <form method="POST" action="{{route('jobcontent.store')}}" enctype="multipart/form-data" id="myForm"> @csrf

               <div class="form-row">

                <div class="form-group col-md-6">
                 <label for="name">Designation Name</label>
                 <input type="text" name="name" class="form-control">
                 <font style="color:red">{{($errors->has('name'))?($errors->first('name')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                </div>
         
                <div class="form-group col-md-6">
                 <label for="job_vacancy">Job Vacancy</label>
                 <input type="text" name="job_vacancy" class="form-control">
                 <font style="color:red">{{($errors->has('job_vacancy'))?($errors->first('job_vacancy')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                 <label for="job_content">Job Content</label>
                 <input type="text" name="job_content" class="form-control">
                 <font style="color:red">{{($errors->has('job_content'))?($errors->first('job_content')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                 <label for="employment_status">Employment Status</label>
                 <input type="text" name="employment_status" class="form-control">  
                </div>

                <div class="form-group col-md-6">
                 <label for="salary">Salary</label>
                 <input type="text" name="salary" class="form-control">
                 <font style="color:red">{{($errors->has('salary'))?($errors->first('salary')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                 <label for="workplace">Workplace</label>
                 <input type="text" name="workplace" class="form-control">
                 <font style="color:red">{{($errors->has('workplace'))?($errors->first('workplace')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                 <label for="joblocation">Job Location</label>
                 <input type="text" name="joblocation" class="form-control">
                </div>

                <div class="form-group col-md-6">
                 <label for="educational">Educational Requirements</label>
                 <textarea id="summernote3" name="educational" type="text"></textarea>
                 <font style="color:red">{{($errors->has('educational'))?($errors->first('educational')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                 <label for="experience">Experience Requirements</label>
                 <textarea id="summernote2" name="experience" type="text"></textarea>
                </div>

                <div class="form-group col-md-6">
                 <label for="responsibilities">Job Responsibilities</label>
                 <textarea id="summernote" name="responsibilities" type="text"></textarea>
                 <font style="color:red">{{($errors->has('responsibilities'))?($errors->first('responsibilities')):'' }}</font>
                </div>

                <div class="form-group col-md-6">
                 <label for="benefits">Other Benefits</label>
                 <textarea id="summernote1" name="benefits" type="text"></textarea>
                </div>

                <div class="form-group col-md-6">
                 <label for="last_date">Apply Last Date</label>
                 <input type="date" name="last_date" class="form-control">
                 <font style="color:red">{{($errors->has('last_date'))?($errors->first('last_date')):'' }}</font>
                </div>
                
                <div class="form-group col-md-6">
                 <label for="status">Status</label>
                 <select name="status" class="form-control">
                  <option value="">Select Role</option>
                  <option value="0">Active</option>
                  <option value="1">Inactive</option>
                 </select>
                  <font style="color:red">{{($errors->has('status'))?($errors->first('status')):'' }}</font>
                </div>

           

                <div class="form-group col-md-12">
                 <input type="submit" value="Upload"  class="btn btn-primary">
                </div>

                </div>
               </form>

        
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->




 <script>
$(function () {
  $('#myForm').validate({
    rules: {
    name: {
     required: true,
    },
    job_vacancy: {
     required: true,
    },

    job_content: {
     required: true,
    },
    salary: {
     required: true,
    },
    workplace: {
     required: true,
    },

    educational: {
     required: true,
    },

    responsibilities: {
     required: true,
    },

    last_date: {
     required: true,
    },

    status: {
     required: true,
    },


    },

    messages: {
     name: {
        required: "Please Enter Job Name",
      },
     job_vacancy: {
        required: "Please Enter Job Vacancy",
      },
       job_content: {
        required: "Please Enter Job Content",
      },
      salary: {
        required: "Please Enter Salary",
      },
      workplace: {
        required: "Please Enter Work Place",
      },
      educational: {
        required: "Please Enter Educational Requirements",
      },
      responsibilities: {
        required: "Please Enter Responsibilities",
      },
      last_date: {
        required: "Please Enter Submit Last Date",
      },

      status: {
        required: "Please Select Option",
      },

    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>


  @endsection