@extends('backend.layouts.master')
@section('content')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Client</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Client</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

 <!-- Main content -->
 <section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">

        <div class="card">
         <div class="card-header">
          <h3>Client List
           <a href="{{route('client.add')}}" class=" btn btn-success btn-sm float-right"> <i class="fa fa-plus-circle"></i> Add Client</a>
          </h3>
         </div>
         
         <!-- /.card-header -->
         <div class="card-body">
          <table id="example1" class="table table-bordered table-striped">
                  
                <thead>
                  <tr>
                    <th>Sl</th>
                    <th>Name</th>
                    <th align="center">Image</th>
                    <th align="center">Status</th>
                    <th align="center">Action</th>
                  </tr>
                  </thead>

                  <tbody>

                  @foreach($alldata as$client)
                  <tr>
                    <td>{{$client->sl}}</td>
                    <td>{{$client->name}}</td>
                    <td>
                     <center><img src="{{(!empty($client->image))?url('public/upload/client_image/'.$client->image):url('public/upload/No-image.jpg')}}" width="130px;" height="70px;"></center></td>

                     <td align="center">
                       @if($client->status=='0')
                        <a href="{{route('client.inacative',$client->id)}}" class="btn btn-primary btn-sm">Active</a>
                       @else
                        <a href="{{route('client.active',$client->id)}}" class="btn btn-danger btn-sm">Inactive</a>
                       @endif

                     </td>
              
                    <td>           
                      <a title="Edit" href="{{route('client.edit',$client->id)}}" class="btn btn-sm btn-primary" ><i class="fa fa-edit"></i></a>

                      <a title="Delete" href="{{route('client.delete',$client->id)}}" id="delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>

                    </td>

                   
                  </tr>

                   @endforeach



                </table>
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  @endsection