<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\model\setting;
use Auth;

class websettingController extends Controller
{

  //-----auth--------//
  public function __construct()
  {
   $this->middleware('auth');
  }

  //------view------//
  public function view()
  {
   $data['countsetting']= setting::count();
   $data['allData'] =setting::all();
   return view('backend.webSetting.webSetting_view',$data);
  } 


  //-----add------//
  public function add()
  {
   return view('backend.webSetting.webSetting_add');
  }

  //------store------//
  public function store(Request $Request)
   {
    $this->validate($Request,[
    'cell'   =>'required',
    'email'  =>'required',
    'address'=>'required',
    ]);

    $data= new setting();
    $data->cell      =$Request->cell;
    $data->ip_phone  =$Request->ip_phone;
    $data->fax       =$Request->fax;
    $data->email     =$Request->email;
    $data->facebook  =$Request->facebook;
    $data->address   =$Request->address;
    
    $data->save();
     return redirect()->route('web_setting.view')->with('success','Data Insert Successfully');
   }


  //-----edit-------//
   public function edit($id)
    {
     $editData=setting::find($id);
     return view('backend.webSetting.webSetting_edit',compact('editData'));
    }

   //------update-----//
   public function update(Request $Request,$id)
    {
     $this->validate($Request,[
     'cell'    =>'required',
     'email'   =>'required',
     'address' =>'required',
      ]);
     
      $data= setting::find($id);
      $data->cell     =$Request->cell;
      $data->ip_phone =$Request->ip_phone;
      $data->fax      =$Request->fax;
      $data->email    =$Request->email;
      $data->facebook =$Request->facebook;
      $data->address  =$Request->address;
      $data->save();
      return redirect()->route('web_setting.view')->with('success','Data Updated Successfully');
    }
    
   //------delete----//
    public function delete($id)
    {
     $user= setting::find($id);
     $user->delete();
     return redirect()->route('web_setting.view')->with('success','Data Deleted Successfully');
    }  
}