<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\employer;

class teamController extends Controller
{
  
 //-----auth-----//
 public function __construct()
  {
   $this->middleware('auth');
  }

  //----view-----//
  public function view()
   {
    $data['alldata'] = employer::all();
    return view('backend.team.view-team',$data);
   }
   
 //-----add----//
  public function add()
  {
   return view('backend.team.add-team');
  }

 //-----store----//
  public function store(Request $Request)
   {
    $this->validate($Request,[
    'sl'         =>'required',
    'name'       =>'required',
    'designation'=>'required',
    'status'     =>'required'
     ]);

     $data=new employer();
     $data->sl          = $Request->sl;
     $data->name        = $Request->name;
     $data->designation = $Request->designation;
     $data->education   = $Request->education;
     $data->experience  = $Request->experience;
     $data->facebook    = $Request->facebook;
     $data->linkedin    = $Request->linkedin;
     $data->status      = $Request->status;
     $data->created_by=Auth::user()->id;
     
     if($Request->file('image'))
      {
       $file=$Request->file('image');
       $filename=date('YmdHi').$file->getClientOriginalname();
       $file->move(public_path('upload/team_image/'),$filename);
       $data['image']=$filename;
      }
      $data->save();
      return redirect()->route('team.view')->with('success','Data Insert Successfully');
    }

  //-----delete------//
  public function delete($id)
   {
    $team=employer::find($id);
    if(file_exists('public/upload/team_image/'.$team->image) AND !empty($team->image)){
    @unlink('public/upload/team_image/'.$team->image);
    }
    $team->delete();
    return redirect()->route('team.view')->with('error','Data Deleted Successfully');
   }


  //-----edit-----//
  public function edit($id)
   {
    $editData=employer::find($id);
    return view('backend.team.edit-team',compact('editData'));
   }

  //------update--------//
  public function update (Request $Request,$id)
   {

    $this->validate($Request,[
    'sl'         =>'required',
    'name'       =>'required',
    'designation'=>'required',
    'status'     =>'required'
     ]);

    $data=employer::find($id);
    $data->sl          = $Request->sl;
    $data->name        = $Request->name;
    $data->designation = $Request->designation;
    $data->education   = $Request->education;
    $data->experience  = $Request->experience;
    $data->facebook    = $Request->facebook;
    $data->linkedin    = $Request->linkedin;
    $data->status      = $Request->status;
    $data->updated_by=Auth::user()->id;

    if($Request->file('image')){
     $file = $Request->file('image');
     @unlink(public_path('upload/team_image/'.$data->image));
     $filename =date('YmdHi').$file->getClientOriginalName();
     $file->move(public_path('upload/team_image/'),$filename);
     $data['image'] = $filename;
     }
    
    $data->save();
    return redirect()->route('team.view')->with('success','Data Updated Successfully');
   }

  //-------inactive--------//
  public function inacative($id)
   {
    employer::find($id)->where('id',$id)->update(['status'=>1]);
    return redirect()->back();
   }

 //------active-------//
  public function active($id)
  {
    employer::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
  }

}