<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\solition;


class solutionController extends Controller
{
  //----auth-----//
  public function __construct()
  {
   $this->middleware('auth');
  }

  //----view-------//
  public function view()
   {
    $data['alldata'] = solition::all();
    return view('backend.soution.view-soution',$data); 
   }
   
  
  //-----add-------//
  public function add()
   {
    return view('backend.soution.add-soution');
   }

 //-----store----//
  public function store(Request $Request)
   {
    $this->validate($Request,[
    'sl'=>'required',
    'title'=>'required',
    'description'=>'required',
    'status'=>'required',
    'image'=>'required'
    ]);

    $data=new solition();
    $data->sl          = $Request->sl;
    $data->title       = $Request->title;
    $data->heading     = $Request->heading;
    $data->detalis     = $Request->detalis;
    $data->description = $Request->description;
    $data->status      = $Request->status;
    $data->created_by=Auth::user()->id;
     if($Request->file('image'))
      {
       $file=$Request->file('image');
       $filename=date('YmdHi').$file->getClientOriginalname();
       $file->move(public_path('upload/solution_image'),$filename);
       $data['image']=$filename;
      }
     $data->save();
     return redirect()->route('solution.view')->with('success','Data Insert Successfully');
   }
    
  //-----delete-------//
   public function delete ($id)
    {
     $slider=solition::find($id);
     if(file_exists('public/upload/solution_image/'.$slider->image) AND !empty($slider->image)){
     unlink('public/upload/solution_image/'.$slider->image);
     }
     $slider->delete();
     return redirect()->route('solution.view')->with('error','Data Deleted Successfully');
    }

   //----edit-----//
   public function edit($id)
    {
     $editData=solition::find($id);
     return view('backend.soution.edit-soution',compact('editData'));
    }
   
   //------update-----//
   public function update(Request $Request,$id)
   {
    $data=solition::find($id);
    $data->sl          = $Request->sl;
    $data->title       = $Request->title;
    $data->heading     = $Request->heading;
    $data->detalis     = $Request->detalis;
    $data->description = $Request->description;
    $data->status      = $Request->status;
    $data->updated_by=Auth::user()->id;
  
    if($Request->file('image'))
    {
     $file=$Request->file('image');
     @unlink(public_path('upload/solution_image/'.$data->image));
     $filename=date('YmdHi').$file->getClientOriginalname();
     $file->move(public_path('upload/solution_image/'),$filename);
     $data['image']=$filename;
    }
     $data->save();
     return redirect()->route('solution.view')->with('success','Data Updated Successfully');
   }


  //------inactive-----//
  public function inacative($id)
   {
    solition::find($id)->where('id',$id)->update(['status'=>1]);
    return redirect()->back();
   }
 
 //----active------//
  public function active($id)
   {
    solition::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
   }

}