<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\model\category;
use App\model\product;  
use DB;
use Auth;

class productController extends Controller
{
  
  //--------auth-------// 
  public function __construct()
   {
    $this->middleware('auth');
   }

 //------add------//
  public function add()
  {
   $data=category::where('status',0)->orderBy('id','DESC')->get();
   return view('backend.product.add-product',compact('data'));
  }

  //-------view-----//
  public function view()
   {
    $data['alldata'] =product::with('category')->get();
    return view('backend.product.view-product',$data);
   }

   //-------store-------//
   public function store(Request $Request)
   {
    $this->validate($Request,[
    // 'category_id' =>'required',
    // 'product_name'=>'required',
    // 'description' =>'required',
    'status'      =>'required'
     ]);

     $data=new product();
     $data->category_id   = $Request->category_id;
     $data->product_name  = $Request->product_name;
     $data->title         = $Request->title;
     $data->short_detalis = $Request->short_detalis;
     $data->description   = $Request->description;
     $data->status        = $Request->status;
     $data->created_by=Auth::user()->id;
     if($Request->file('image'))
     {
      $file=$Request->file('image');
      $filename=date('YmdHi').$file->getClientOriginalname();
      $file->move(public_path('upload/product_image/'),$filename);
      $data['image']=$filename;
     }
     $data->save();
     return redirect()->route('solution.view')->with('success','Data Insert Successfully');
    }

 //------delete------//
  public function delete($id)
   {
    $product=product::find($id);
    if(file_exists('public/upload/product_image/'.$product->image) AND !empty($product->image)){
    unlink('public/upload/product_image/'.$product->image);
    }
    $product->delete();
    return redirect()->route('solution.view')->with('error','Data Deleted Successfully');
   }

  //-----inactive-----//
   public function inacative($id)
   {
    product::find($id)->where('id',$id)->update(['status'=>1]);
    return redirect()->back();
   }

  //----active------//
  public function active($id)
   {
    product::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
   }

  //-------edit-----//
  public function edit($id)
   {
    $editData=product::find($id);
    $data=category::where('status',0)->orderBy('id','DESC')->get();
    return view('backend.product.edit-product',compact('editData','data'));
   }

  //------uddate------//
  public function update (Request $Request,$id)
   {
    $this->validate($Request,[
    // 'category_id' =>'required',
    // 'product_name'=>'required',
    // 'description' =>'required',
    'status'      =>'required'
     ]);

     $data=product::find($id);
     $data->category_id   = $Request->category_id;
     $data->product_name  = $Request->product_name;
     $data->title         = $Request->title;
     $data->short_detalis = $Request->short_detalis;
     $data->description   = $Request->description;
     $data->status        = $Request->status;
     $data->updated_by=Auth::user()->id;

     if($Request->file('image')){
      $file = $Request->file('image');
      @unlink(public_path('upload/product_image/'.$data->image));
      $filename =date('YmdHi').$file->getClientOriginalName();
      $file->move(public_path('upload/product_image/'),$filename);
      $data['image'] = $filename;
      }
    
    $data->save();
    return redirect()->route('solution.view')->with('success','Data Updated Successfully');
   }

}