<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\partner;


class partnerController extends Controller
{
 //-----auth-----//
  public function __construct()
   {
    $this->middleware('auth');
   }

  //------view------//
  public function view()
  {
   $data['alldata']=partner::all();
   return view('backend.partner.view-partner',$data);
  }
  
  //-------add--------//
  public function add()
  {
   return view('backend.partner.add-partner');
  }

  //--------store-------//
  public function store(Request $Request)
   {
    $this->validate($Request,[
    'sl'    =>'required',
    'name'  =>'required',
    'status'=>'required'
    ]);

     $data = new partner();
     $data->sl      = $Request->sl;
     $data->name    = $Request->name;
     $data->status  = $Request->status;
     $data->created_by=Auth::user()->id;
     
     if($Request->file('image'))
     {
      $file=$Request->file('image');
      $filename=date('YmdHi').$file->getClientOriginalname();
      $file->move(public_path('upload/partner_image/'),$filename);
      $data['image']=$filename;
     }
     $data->save();
     return redirect()->route('partner.view')->with('success','Data Insert Successfully');
    }

  //-------delete--------//
   public function delete($id)
   {
    $partner = partner::find($id);
     if(file_exists('public/upload/partner_image/'.$partner->image) AND !empty($partner->image)){
     @unlink('public/upload/partner_image/'.$partner->image);
    }
    $partner->delete();
    return redirect()->route('partner.view')->with('error','Data Deleted Successfully');
   }

   //----inactive------//
   public function inacative($id)
   {
    partner::find($id)->where('id',$id)->update(['status'=>1]);
    return redirect()->back();
   }

   //-----active-------//
   public function active($id)
   {
    partner::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
   }

   //--------edit-------////
   public function edit($id)
   {
    $editData=partner::find($id);
    return view('backend.partner.edit-partner',compact('editData'));
   }

   //-----update-------//
   public function update(Request $Request,$id)
    {
     $this->validate($Request,[
      'sl'    =>'required',
      'name'  =>'required',
      'status'=>'required'
     ]);

      $data=partner::find($id);

      $data->sl        = $Request->sl;
      $data->name      = $Request->name;
      $data->status    = $Request->status;
      $data->updated_by=Auth::user()->id;
  
     if($Request->file('image'))
      {
        $file=$Request->file('image');
        @unlink(public_path('upload/partner_image/'.$data->image));
        $filename=date('YmdHi').$file->getClientOriginalname();
        $file->move(public_path('upload/partner_image'),$filename);
        $data['image']=$filename;
      }
       $data->save();
       return redirect()->route('partner.view')->with('success','Data Updated Successfully');
    }

}