<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\Logo;

class logoController extends Controller
{
  //-----auth------//
  public function __construct()
  {
   $this->middleware('auth');
  }

  //------view------//
  public function view()
   {
    $data['countlogo']= Logo::count();
    $data['allData'] =logo::all();
    return view('backend.logo.view-logo',$data);
   }

  //------add-------//
  public function add()
   {
    return view('backend.logo.add-logo');
   }

  //------store------//
  public function store(Request $Request)
  {
   $this->validate($Request,[
   'image'=>'required'
    ]);

    $data= new Logo();
      $data->created_by=Auth::user()->id;
      if($Request->file('image')){
       $file = $Request->file('image');
       $filename =date('YmdHi').$file->getClientOriginalName();
       $file->move(public_path('upload/logo_images/'),$filename);
       $data['image'] = $filename;
      }
      $data->save();
      return redirect()->route('logo.view')->with('success','Data Insert Successfully');
    }

   //-------edit-------//
   public function edit($id)
    {
     $editData=Logo::find($id);
     return view('backend.logo.edit-logo',compact('editData'));
    }

   //--------update------//
    public function update(Request $Request,$id)
    {
     $data= Logo::find($id);
     $data->update_by=Auth::user()->id;
    
      if($Request->file('image')){
      $file = $Request->file('image');
      @unlink(public_path('upload/logo_images/'.$data->image));
      $filename =date('YmdHi').$file->getClientOriginalName();
      $file->move(public_path('upload/logo_images/'),$filename);
      $data['image'] = $filename;
     }
     $data->save();
     return redirect()->route('logo.view')->with('success','Data Insert Successfully');
    }

   //------delete-----//
    public function delete($id)
    {
     $logo= Logo::find($id);

     if(file_exists('public/upload/logo_images/'.$logo->image) AND !empty($logo->image))
     {
      unlink('public/upload/logo_images/' .$logo->image);
     }
     $logo->delete();
     return redirect()->route('logo.view')->with('success','Data Deleted Successfully');
    } 
    
  }