<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\career;


class jobcontentController extends Controller
{

 //-------auth-----//
	public function __construct()
 {
  $this->middleware('auth');
 }

 //------view-------//
 public function view()
  {
   $data['alldata'] =career::all();
   return view('backend.jobcontect.view-jobcontect',$data);
  }

 //------add--------//
 public function add()
  {
   return view('backend.jobcontect.add-jobcontect');
  }
  

 //--------store-----//
 public function store(Request $Request)
  {
   $this->validate($Request,[
   'name'            =>'required',
   'job_vacancy'     =>'required',
   'job_content'     =>'required',
   'salary'          =>'required',
   'workplace'       =>'required',
   'educational'     =>'required',
   'responsibilities'=>'required',
   'last_date'       =>'required',
   'status'          =>'required'
   ]);

     $data=new career();
     $data->name               = $Request->name;
     $data->job_vacancy        = $Request->job_vacancy;
     $data->job_content        = $Request->job_content;
     $data->employment_status  = $Request->employment_status;
     $data->salary             = $Request->salary;
     $data->workplace          = $Request->workplace;
     $data->joblocation        = $Request->joblocation;
     $data->educational        = $Request->educational;
     $data->experience         = $Request->experience;
     $data->responsibilities   = $Request->responsibilities;
     $data->benefits           = $Request->benefits;
     $data->last_date          = $Request->last_date;
     $data->status             = $Request->status;
     $data->created_by=Auth::user()->id;

     $data->save();
     return redirect()->route('jobcontent.view')->with('success','Data Insert Successfully');
    }

  //------delete------//
  public function delete($id)
   {
    $career=career::find($id);
    $career->delete();
    return redirect()->route('jobcontent.view')->with('error','Data Deleted Successfully');
   }
    
   //--------inactive------//
   public function inacative($id)
   {
    career::find($id)->where('id',$id)->update(['status'=>1]);
    return redirect()->back();
   }

   //------active------/
   public function active($id)
   {
    career::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
   }

   //--------edit------//
   public function edit($id)
    {
     $editData=career::find($id);
     return view('backend.jobcontect.edit-jobcontect',compact('editData'));
    }

   //-------update----//
   public function update(Request $Request,$id)
   {
   $this->validate($Request,[
    'name'=>'required',
    'job_vacancy'=>'required',
    'job_content'=>'required',
    'salary'=>'required',
    'workplace'=>'required',
    'educational'=>'required',
    'responsibilities'=>'required',
    'last_date'=>'required',
    'status'=>'required'
    ]);

     $data=career::find($id);
     $data->name = $Request->name;
     $data->job_vacancy = $Request->job_vacancy;
     $data->job_content = $Request->job_content;
     $data->employment_status = $Request->employment_status;
     $data->salary = $Request->salary;
     $data->workplace = $Request->workplace;
     $data->joblocation = $Request->joblocation;
     $data->educational = $Request->educational;
     $data->experience = $Request->experience;
     $data->responsibilities = $Request->responsibilities;
     $data->benefits = $Request->benefits;
     $data->last_date = $Request->last_date;
     $data->status = $Request->status;
     $data->updated_by=Auth::user()->id;
     $data->save();
     return redirect()->route('jobcontent.view')->with('success','Data Updated Successfully');
    }

}
