<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\gallery;

class galleryController extends Controller
{

 //------auth-------//
 public function __construct()
  {
   $this->middleware('auth');
  }


 //-------view--------//
 public function view()
  {
   $data['alldata'] =gallery::all();
   return view('backend.gallery.view-gallery',$data);
  }

 //----------add--------//
 public function add()
  {
   return view('backend.gallery.add-gallery');
  }

 //-----store----------//
 public function store(Request $Request)
  {
   $this->validate($Request,[
   'image'   =>'required',
    'status' =>'required'
    ]);

    $data=new gallery();
    $data->title     = $Request->title;
    $data->status    = $Request->status;
    $data->created_by=Auth::user()->id;
    
    if($Request->file('image'))
     {
      $file=$Request->file('image');
      $filename=date('YmdHi').$file->getClientOriginalname();
      $file->move(public_path('upload/gallery_image/'),$filename);
      $data['image']=$filename;
     }
    $data->save();
    return redirect()->route('gallery.view')->with('success','Data Insert Successfully');
   }


  //------inactive------//
  public function inacative($id)
   {
    gallery::find($id)->where('id',$id)->update(['status'=>1]);
    return redirect()->back();
   }


  //----------active------//
  public function active($id)
  {
    gallery::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
  }

 //------delete------//
  public function delete($id)
   {
   $blog=gallery::find($id);
   if(file_exists('public/upload/gallery_image/'.$blog->image) AND !empty($blog->image)){
    unlink('public/upload/gallery_image/'.$blog->image);
   }
   $blog->delete();
   return redirect()->route('gallery.view')->with('error','Data Deleted Successfully');
   }

 //--------edit-------//
  public function edit($id)
   {
    $editData=gallery::find($id);
    return view('backend.gallery.edit-gallery',compact('editData'));
   }

   //-------update-------//
   public function update(Request $Request,$id)
    {
    $this->validate($Request,[
      'image'  =>'required',
      'status' =>'required'
     ]);

    $data=gallery::find($id);
    $data->title     = $Request->title;
    $data->status    = $Request->status;
    $data->updated_by=Auth::user()->id;
  
    if($Request->file('image'))
     {
      $file=$Request->file('image');
      @unlink(public_path('upload/gallery_image/'.$data->image));
      $filename=date('YmdHi').$file->getClientOriginalname();
      $file->move(public_path('upload/gallery_image'),$filename);
      $data['image']=$filename;
     }
    $data->save();
    return redirect()->route('gallery.view')->with('success','Data Updated Successfully');
   }
   
}