<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\model\contuct;
use Auth;

class contuctController extends Controller
{

  //-------auth-----//
  public function __construct()
  {
   $this->middleware('auth');
  }

  //--------view------//
  public function view()
   {
    $data['allData'] =contuct::all();
    return view('backend.conauct.view-contuct',$data);
   } 
 
  //-------add--------//
  public function add()
   {
    return view ('backend.conauct.add-contuct');
   }


  //------store-------//
  public function store(Request $Request)
   {

    $this->validate($Request,[
     'contuctlavel'=>'required',
     'status'      =>'required',
    ]);
      
    $data= new contuct();
    $data->contuctlavel =$Request->contuctlavel;
    $data->phone        =$Request->phone;
    $data->ip           =$Request->ip;
    $data->email        =$Request->email;
    $data->emailone     =$Request->emailone;
    $data->social       =$Request->social;
    $data->status       =$Request->status;
    $data->created_by   =Auth::user()->id;

    $data->save();
    return redirect()->route('contuct.view')->with('success','Data Insert Successfully');
   }

   //--------delete-------//
   public function delete($id)
    {
     $user= contuct::find($id);     
     $user->delete();
     return redirect()->route('contuct.view')->with('success','Data Deleted Successfully');
    } 

   //------edit--------//
    public function edit($id)
     {
      $editData=contuct::find($id);
      return view('backend.conauct.edit-contuct',compact('editData'));
     }

    //-------update-------//
    public function update(Request $Request,$id)
    {
    $this->validate($Request,[
        'contuctlavel' =>'required',
        'status'       =>'required',
      ]);
     
      $data= contuct::find($id);
      $data->contuctlavel=$Request->contuctlavel;
      $data->phone       =$Request->phone;
      $data->ip          =$Request->ip;
      $data->social      =$Request->social;
      $data->status      =$Request->status;
      $data->updated_by  =Auth::user()->id;
      $data->save();
      return redirect()->route('contuct.view')->with('success','Data Updated Successfully');
    }
   
   //--------inactive-------//
    public function inacative($id)
     {
      contuct::find($id)->where('id',$id)->update(['status'=>1]);
      return redirect()->back();
     }

   //---------active-------//
    public function active($id)
     {
      contuct::find($id)->where('id',$id)->update(['status'=>0]);
      return redirect()->back();
    }

}