<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\client;

class clientController extends Controller
{
  
  //------auth-----//
  public function __construct()
   {
    $this->middleware('auth');
   }

   //-------view------//
   public function view()
    {
     $data['alldata'] =client::all();
     return view('backend.client.view-client',$data);
    }

   //-------add--------//
   public function add()
    {
     return view('backend.client.add-client');
    }

   //------store-----//
   public function store(Request $Request)
    {
     $this->validate($Request,[
     'sl'    =>'required',
     'name'  =>'required',
     'status'=>'required'
     ]);

     $data=new client();   
     $data->sl        = $Request->sl;
     $data->name      = $Request->name;
     $data->status    = $Request->status;
     $data->created_by=Auth::user()->id;
      
     if($Request->file('image'))
      {
       $file=$Request->file('image');
       $filename=date('YmdHi').$file->getClientOriginalname();
       $file->move(public_path('upload/client_image/'),$filename);
       $data['image']=$filename;
      }
      $data->save();
      return redirect()->route('client.view')->with('success','Data Insert Successfully');
    }
  
    //--------delete-----//
    public function delete($id)
    {
      $client=client::find($id);
       if(file_exists('public/upload/client_image/'.$client->image) AND !empty($client->image)){
       @unlink('public/upload/client_image/'.$client->image);
      }
      $client->delete();
      return redirect()->route('client.view')->with('error','Data Deleted Successfully');
    }

   //------inactive----//
   public function inacative($id)
    {
     client::find($id)->where('id',$id)->update(['status'=>1]);
     return redirect()->back();
    }

   //------active----//
   public function active($id)
   {
    client::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
   }
   
   //-----edit----//
   public function edit($id)
    {
     $editData=client::find($id);
     return view('backend.client.edit-client',compact('editData'));
    }

   //-------update------//
   public function update(Request $Request,$id)
    {
     $this->validate($Request,[
     'sl'    =>'required',
     'name'  =>'required',
     'status'=>'required'
     ]);

      $data=client::find($id);

      $data->sl        = $Request->sl;
      $data->name      = $Request->name;
       $data->status   = $Request->status;
      $data->updated_by=Auth::user()->id;
  
    if($Request->file('image'))
    {
     $file=$Request->file('image');
     @unlink(public_path('upload/client_image/'.$data->image));
     $filename=date('YmdHi').$file->getClientOriginalname();
     $file->move(public_path('upload/client_image'),$filename);
     $data['image']=$filename;
    }
    $data->save();
    return redirect()->route('client.view')->with('success','Data Updated Successfully');
   }

}