<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\category;


class categoryController extends Controller
{
 
 //------Auth---------//
 public function __construct()
  {
   $this->middleware('auth');
  }


//-----View-------//
 public function view()
  {
   $data['alldata'] =category::all();
   return view('backend.product.view-category',$data);
  }

 //-------Add--------//
 public function add()
  {
   return view('backend.product.add-category');
  }


 public function store(Request $Request)
  {
   $this->validate($Request,[
   'category_name'=>'required',
   'status'       =>'required'
   ]);

    $data=new category();
    $data->category_name = $Request->category_name;
    $data->status        = $Request->status;
    $data->created_by    =Auth::user()->id;
     
    if($Request->file('image'))
     {
      $file=$Request->file('image');
      $filename=date('YmdHi').$file->getClientOriginalname();
      $file->move(public_path('upload/category_image/'),$filename);
      $data['image']=$filename;
     }
    $data->save();
    return redirect()->route('category.view')->with('success','Data Insert Successfully');
  }


  //-----delete-------//
  public function delete($id)
   {
   $category=category::find($id);
   if(file_exists('public/upload/category_image/'.$category->image) AND !empty($category->image)){
    unlink('public/upload/category_image/'.$category->image);
   }
   $category->delete();
   return redirect()->route('category.view')->with('error','Data Deleted Successfully');
   }

  //-------inactive-------//
   public function inacative($id)
    {
     category::find($id)->where('id',$id)->update(['status'=>1]);
     return redirect()->back();
    }

   //------active-----//
   public function active($id)
   {
    category::find($id)->where('id',$id)->update(['status'=>0]);
    return redirect()->back();
   }
  
   //-----edit----//
   public function edit($id)
    {
     $editData=category::find($id);
     return view('backend.product.edit-category',compact('editData'));
    }

   //-----update------//
   public function update (Request $Request,$id)
    {

     $this->validate($Request,[
      'category_name'=>'required',
      'status'       =>'required'
     ]);


     $data=category::find($id);
     $data->category_name = $Request->category_name;
     $data->status        = $Request->status;
     $data->updated_by    =Auth::user()->id;


     if($Request->file('image')){
      $file = $Request->file('image');
      @unlink(public_path('upload/category_image/'.$data->image));
      $filename =date('YmdHi').$file->getClientOriginalName();
      $file->move(public_path('upload/category_image/'),$filename);
      $data['image'] = $filename;
      }
    
      $data->save();
      return redirect()->route('category.view')->with('success','Data Updated Successfully');
    }

}