<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\blog;


class blogController extends Controller
{

 //-----auth------//
  public function __construct()
   {
    $this->middleware('auth');
   }

  //-------view-----//
  public function view()
   {
    $data['alldata'] =blog::all();
    return view('backend.blog.view-blog',$data);
   }

  //-------add-----//
  public function add()
   {
    return view('backend.blog.add-blog');
   }
    
  //-------store------//  
  public function store(Request $Request)
   {
    $this->validate($Request,[
    'title'       =>'required',
    'email'       =>'required',
    'message'     =>'required'
    ]);

    $data=new blog();
    $data->title       = $Request->title;
    $data->detalis     = $Request->detalis;
    $data->description = $Request->description;
    $data->status      = $Request->status;
    $data->created_by  =Auth::user()->id;

    if($Request->file('image'))
    {
     $file=$Request->file('image');
     $filename=date('YmdHi').$file->getClientOriginalname();
     $file->move(public_path('upload/blog_image'),$filename);
     $data['image']=$filename;
    }
     $data->save();
     return redirect()->route('blog.view')->with('success','Data Insert Successfully');
   }
 
   //--------delete----//
   public function delete($id)
    {
     $blog=blog::find($id);
     if(file_exists('public/upload/blog_image/'.$blog->image) AND !empty($blog->image)){
     unlink('public/upload/blog_image/'.$blog->image);
    }
   
    $blog->delete();
    return redirect()->route('blog.view')->with('error','Data Deleted Successfully');
   }
   
   //--------edit------//
   public function edit($id)
    {
     $editData=blog::find($id);
     return view('backend.blog.edit-blog',compact('editData'));
    }

   //-------update-----//
   public function update(Request $Request,$id)
    {
     $this->validate($Request,[
      'title'      =>'required',
      'description'=>'required',
      'status'     =>'required'
     ]);

     $data=blog::find($id);
     $data->title       = $Request->title;
     $data->detalis     = $Request->detalis;
     $data->description = $Request->description;
     $data->status      = $Request->status;
     $data->updated_by  = Auth::user()->id;
  
     if($Request->file('image'))
      {
       $file=$Request->file('image');
       @unlink(public_path('upload/blog_image/'.$data->image));
       $filename=date('YmdHi').$file->getClientOriginalname();
       $file->move(public_path('upload/blog_image'),$filename);
       $data['image']=$filename;
      }
      $data->save();
      return redirect()->route('blog.view')->with('success','Data Updated Successfully');
    }


    //------inactive----//
    public function inacative($id)
     {
      blog::find($id)->where('id',$id)->update(['status'=>1]);
      return redirect()->back();
     }
    
    //-----active-------//
    public function active($id)
     {
      blog::find($id)->where('id',$id)->update(['status'=>0]);
      return redirect()->back();
     }
  }