<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\model\about;

class aboutController extends Controller
{
 
 //-----Auth-----/
 public function __construct()
  {
   $this->middleware('auth');
  }

  //------view------//
  public function view()
   {
    $data['countabout']= about::count();
    $data['allData']   =about::all();
    return view('backend.about.view-about',$data);
   }

  //------Add--------//
  public function add()
   {
    return view('backend.about.add-about');
   }

 //--------store------//
  public function store(Request $Request)
   {
    $data= new about();
    $data->about     = $Request->about;
    $data->created_by=Auth::user()->id;
    
    if($Request->file('image')){
     $file = $Request->file('image');
     $filename =date('YmdHi').$file->getClientOriginalName();
     $file->move(public_path('upload/about_images/'),$filename);
     $data['image'] = $filename;
     }
     $data->save();
     return redirect()->route('about.view')->with('success','Data Insert Successfully');
    }

   //-------edit-------//
   public function edit($id)
    {
     $editData=about::find($id);
     return view('backend.about.edit-about',compact('editData'));
    }
    
   //-------update------// 
   public function update(Request $Request,$id)
    {
     $data= about::find($id);
     $data->about = $Request->about;
     $data->updated_by=Auth::user()->id;
     
     if($Request->file('image')){
      $file = $Request->file('image');
      @unlink(public_path('upload/about_images/'.$data->image));
      $filename =date('YmdHi').$file->getClientOriginalName();
      $file->move(public_path('upload/about_images/'),$filename);
      $data['image'] = $filename;
      }
     $data->save();
     return redirect()->route('about.view')->with('success','Data Updated Successfully');
    }
    
    //------delete-----//
    public function delete($id)
    {
     $about= about::find($id);
     if(file_exists('public/upload/about_images/'.$about->image) AND !empty($about->image))
      {
       unlink('public/upload/about_images/' .$about->image);
      }
      $about->delete();
      return redirect()->route('about.view')->with('success','Data Deleted Successfully');
    } 


}